/*------------------------------------------------------------------------------*
 *      File Name:      oEvents.h												*
 *      Purpose:		events ID's to shared between ok and OC					*
 *      Date:			07/14/2003												*
 *		Creator:		YuI														*
 *      Copyright OriginLab Corp. 2002, 2003, 2004								*
 *      Modification log                                                        *
 *	YuI 12/05/03 v7.5778 QA70-5613 OC_CMDTARGET_HANDLER_FOR_ORIGIN_OBJECTS		*
 *	YuI 1/20/04 v7.5806 QA70-5853 OGS_EVENTS_WITH_PROJECT_IN_COMMAND_LINE		*
 *	YuI 3/23/04 v7.5843 QA70-6141 MORE_OGS_EVENTS								*
 *	TD 5-28-04 QA70-5346 EDITING_DIALOGBUILDER_GRAPHS_IN_ORIGIN_WORKSPACE		*
 *	TD 8-30-04 QA70-6853  GRID_IN_OC											
 *	ML 9/15/2004 QA70-5770 QA70-6878 ANALYSIS_MENUS_OC_HANDLING					*
 *	TD 10-8-04 GETNDIALOG_TO_EDIT_WORKSHEET_PROPERTIES							*
 *	YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK				*
 *	TD 11-4-04 QA70-7124 GENERAL_EVENTS_FIRED_ON_IMPORT							*
 *	TD 11-10-04 QA70-5346 EDITING_DIALOGBUILDER_GRAPHS_IN_ORIGIN_WORKSPACE		*
 *	TD 11-12-04 QA70-7027 EVENT_HANDLING_ETC_FOR_OK								*
 *	ML 12/22/2004 UNIFIED_GRID_CONTEXT_MENU_HANDLING							*
 *	RVD 2/16/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT							*
 *	RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS							*
 *	DSC ML 4/1/05 QA70-7500 v8.0215 GET_XF_FROM_ACCELERATOR						*
 *	YuI 04/22/05 QA70-6857 OBJECT_CONNECTION_IMPLEMENTATION						*
 *	ML 5/3/2005 QA70-7686 X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION					*
 *	CPY 5/24/05 QA70-7756 GRAPH_XF_OPEN_DIALOG_BY_POST_MSG						*
 *	CPY 12/1/05 QA70-8292 MAT_OBJ_PROP_DIALOG_WHEN_DBL_CLICK					*
 *	RVD 4/7/2006 QA70-8609 v8.0387 TABLE_GRID_BORDERS							*
 *	CPY 8/18/06 REPORT_SHEET_SHOULD_HAVE_DIFF_THEME								*
 *	TD 9-11-06 QA70-8950 NEW_SPARKLINE_GRAPHS									*
 *	RVD 2/19/2007 QA70-9371 v8.0566 WKS_SELECTION_FILL							*
 *	TD 4-12-07 QA70-9603 OC_CONTROLLED_DIALOGBARS_AUTOLAUNCH_ON_ORIGIN_BEGIN	*
 *	RVD 6/14/2007 QA80-9872 v8.0642 SELECT_EVENT_OBJECT_ONLY					*
 *	ML 6/22/2007 CANNOT_INSERT_MUST_APPEND_NEW_EVENT_VALUES						*
 *	Arvin 07/04/07 OPEN_OR_CLOSE_DATA_INFO_DLG									*
 *	RVD 4/1/2008 QA70-11338 v8.0836 DELETE_POLYLINE_SELECTED_POINT				*
 *	RVD 12/19/2008 qa70-12823 v8.0989 GROBJ_POST_MSG_NOT_RECEIVED				*
 *	RVD 1/23/2009 QA80-13011 PA_MARKER_ACTIVATION								*
 *	RVD 2/17/2009 QA70-13131 ANCHOR_KEY_EVENTS									*
 *	Sophy 12/4/2009 QA80-14799 EXPOSE_DATAMASK_EVENT_TO_OC_GRAPHOBJECT			*
 *	TD ML 02-03-2010 QA81-15043 MENU_BUTTON_ON_REPORT_TABLE_TITLES				*
 *	Kyle 05/24/2010 ORG-166 GRAPH_OBJECT_ON_STYLE_CHANGE						*
 *------------------------------------------------------------------------------*/

#ifndef	_OEVENTS_H
#define	_OEVENTS_H

typedef enum	tagORIGINEVENTID
{
	/// RVD 12/19/2008 qa70-12823 v8.0989 GROBJ_POST_MSG_NOT_RECEIVED
	//OE_CREATE_NEW_GRAPH_PAGE_ADD_DATA,	// fires after create new graph page and add data
	OE_NONE = -1,

	OE_CMD_BEGIN = 0,

	// utterly generic Begin and end
	// use according to your needs and common sense
	OE_BEGIN = OE_CMD_BEGIN,
	OE_END,

	OE_MOVE,
	OE_MOVING,
	OE_RESIZE,
	OE_RESIZING,
	OE_DELETE,
	OE_SELECT,
	OE_UNSELECT,
	OE_BUTTONCLICK,
	OE_INIT_ANCHORS,	/// RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS

	//graph object related 
	OE_GRAPHOBJ_ROTATE,
	OE_GRAPHOBJ_ROTATING,
	OE_GRAPHOBJ_SKEW,
	OE_GRAPHOBJ_SKEWING,
	OE_GRAPHOBJ_EDIT,
	OE_GRAPHOBJ_EDITING,

	OE_NEWSELECTION,	/// RVD 6/14/2007 QA80-9872 v8.0642 SELECT_EVENT_OBJECT_ONLY
	OE_DELETE_PART,		/// RVD 4/1/2008 QA70-11338 v8.0836 DELETE_POLYLINE_SELECTED_POINT

	/// RVD 2/17/2009 QA70-13131 ANCHOR_KEY_EVENTS
	OE_KEYDOWN,
	OE_KEYUP,
	/// end ANCHOR_KEY_EVENTS
	///Sophy 12/4/2009 QA80-14799 EXPOSE_DATAMASK_EVENT_TO_OC_GRAPHOBJECT
	OE_DATAMASK_CHANGE,
	///end EXPOSE_DATAMASK_EVENT_TO_OC_GRAPHOBJECT
	OE_STYLE_CHANGE,					///Kyle 05/24/2010 ORG-166 GRAPH_OBJECT_ON_STYLE_CHANGE
	// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! //
	// All new events (< SN_OC_OFFSET) must be appended, rather than inserted above to keep OE_* before SN_OC_OFFSET unchanged
	// This is because these event values might be stored as STR_DATAID_ATTRIB
	// inside tree nodes of xfuncs.
	// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! //

	//OE_SN_BEGIN	= SN_OC_OFFSET,		// 200
	//OE_SN_END	= SN_END_MSG,
	
	OE_WIN_OPEN = 500,
	OE_WIN_CLOSE,
	OE_WIN_ACTIVATE,
	OE_WIN_DEACTIVATE,
	OE_BEFORE_SAVE,
	OE_SCALE_CHANGE,
	OE_UPDATE,	// internal call to UpdateData

	OE_CMD_END,

	OE_OGS_BEGIN,
	OE_MSG_FIRE = OE_OGS_BEGIN,
	OE_MSG_SET_OGS_FILE_NAME,
	OE_OGS_END,

	OE_ORG_BEGIN,
	OE_CREATE_NEW_GRAPH_PAGE_ADD_DATA = OE_ORG_BEGIN,	// fires after create new graph page and add data
	/// end GROBJ_POST_MSG_NOT_RECEIVED

	OE_AFTER_LOAD_FROM_TEMPLATE,		// fires after loading from template
	OE_BEFORE_CNF,						// fires before execution of any CNF file
	OE_AFTER_CNF,						// fires after execution of all CNF files
	OE_BEFORE_COMPILE_SYSTEM,			// fires before startup compilation of system folder
	OE_AFTER_COMPILE_SYSTEM,			// fires after startup compilation of system folder
	OE_BEFORE_OPEN_DOC,					// fires before Origin project is loaded
	OE_AFTER_OPEN_DOC,					// fires after Origin project is loaded
	OE_BEFORE_CLOSE_DOC,				// fires before Origin project is closed
	OE_AFTER_CLOSE_DOC,					// fires after Origin project is closed
	OE_EXIT_ORIGIN,						// fires before exiting origin but after OE_AFTER_CLOSE_DOC\
	/// YuI 1/20/04 v7.5806 QA70-5853 OGS_EVENTS_WITH_PROJECT_IN_COMMAND_LINE
	OE_BEFORE_COMPILE_PROJECT,
	OE_AFTER_COMPILE_PROJECT,
	/// end OGS_EVENTS_WITH_PROJECT_IN_COMMAND_LINE
	/// YuI 3/23/04 v7.5843 QA70-6141 MORE_OGS_EVENTS
	OE_BEFORE_SAVE_DOC,
	OE_AFTER_SAVE_DOC,
	/// end MORE_OGS_EVENTS
	/// TD 5-25-04 QA70-6400 FIRE_OCEVENTS_FOR_WKS_CONTEXT_MENUS
	/// TD 11-12-04 QA70-7027 EVENT_HANDLING_ETC_FOR_OK 
	//OE_ONCONTEXTMENU_WKSLAYER,
	//OE_ONCONTEXTMENU_WKSPAGE,
	OE_CONTEXTMENU,	   //For all wrappers
	/// end EVENT_HANDLING_ETC_FOR_OK 
	OE_ONCONTEXTMENU_SHEET_TAB,
	/// end FIRE_OCEVENTS_FOR_WKS_CONTEXT_MENUS
	/// TD 11-10-04 QA70-5346 EDITING_DIALOGBUILDER_GRAPHS_IN_ORIGIN_WORKSPACE
	/// TD 5-28-04 QA70-5346 EDITING_DIALOGBUILDER_GRAPHS_IN_ORIGIN_WORKSPACE
	//OE_DBPAGE_BEFORE_ATTACH_MDI,
	//OE_DBPAGE_AFTER_ATTACH_MDI,
	//OE_DBPAGE_BEFORE_DETACH_MDI,
	//OE_DBPAGE_AFTER_DETACH_MDI,
	/// end EDITING_DIALOGBUILDER_GRAPHS_IN_ORIGIN_WORKSPACE
	//------
	/// TD 11-12-04 QA70-7027 EVENT_HANDLING_ETC_FOR_OK 
	///// TD 8-30-04 QA70-6853  GRID_IN_OC
	//OE_ONCONTEXTMENU_RESULT_LOG_GRIDCHILD,
	//OE_ONCONTEXTMENU_WKS_GRIDCHILD,
	///// end  GRID_IN_OC
	/// end EVENT_HANDLING_ETC_FOR_OK 
	/// ML 9/15/2004 QA70-5770 QA70-6878 ANALYSIS_MENUS_OC_HANDLING
	OE_ON_CLASS_AWARE_UI_UPDATE,
	OE_ON_CLASS_AWARE_COMMAND,
	/// end ANALYSIS_MENUS_OC_HANDLING
	/// TD 9-13-04 QA70-6376 WORKSHEET_CONTEXT_MORE_WORK
	/// TD 11-12-04 QA70-7027 EVENT_HANDLING_ETC_FOR_OK 
	//OE_ONCONTEXTMENU_WKSFRAME,
	OE_ONCONTEXTMENU_WIN_TITLE_BAR,
	/// end EVENT_HANDLING_ETC_FOR_OK 
	/// TD 10-8-04 GETNDIALOG_TO_EDIT_WORKSHEET_PROPERTIES
	/// end GETNDIALOG_TO_EDIT_WORKSHEET_PROPERTIES
	OE_WORKSHEET_PROPS_DIALOG,
	/// end WORKSHEET_CONTEXT_MORE_WORK

	/// YuI 10/20/04 QA70-7072 v7.5153 CORNER_OBJECT_FOR_NEW_WORKBOOK
	OE_ON_OBJECT_HOT_SPOT_CLICK,
	/// end CORNER_OBJECT_FOR_NEW_WORKBOOK

	/// TD 11-4-04 QA70-7124 GENERAL_EVENTS_FIRED_ON_IMPORT
	//Page Messages
	OE_ON_LAYER_ADD,
	OE_ON_LAYER_REMOVE,
	//Worksheet Messages
	OE_ON_COL_ADD,
	OE_ON_COL_REMOVE,
	/// end GENERAL_EVENTS_FIRED_ON_IMPORT

	OE_NEW_GRID,	/// RVD 2/16/2005 QA70-7289 v8.0185 WKS_THEME_SUPPORT

	OE_XF_ACCEL,				///DSC ML 4/1/05 QA70-7500 v8.0215 GET_XF_FROM_ACCELERATOR
	OE_DATA_READER_EVENT,	/// YuI 04/22/05 QA70-6857 OBJECT_CONNECTION_IMPLEMENTATION
	/// ML 5/3/2005 QA70-7686 X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION
	OE_ON_XF_MENUS_UPDATE,
	OE_ON_XF_MENUS_EXEC,
	/// end X_FUNCTIONS_DRIVEN_MENU_CUSTOMIZATION
	
	//--- CPY 5/24/05 QA70-7756 GRAPH_XF_OPEN_DIALOG_BY_POST_MSG
	OE_ON_ATTACHED_XF_MSG,	// object like gr's XF message
	//---
	
	OE_ONCONTEXTMENU_VERT_TAB,	//CPY 6/30/2005 QA70-7769 v8.0261 MAT_FRAME_BUTTON_OC
	/// YuI 07/26/05 CENTRALIZE_TOOL_EVENTS
	// Originally wanted to use constats from ORIGINCMDTARGETEVENTID
	// since there is already OE_MOVE there
	// but turns out to be not convenient since more event to follow
	OE_TOOL_START,
	OE_TOOL_FINISH,
	OE_TOOL_MOVE,
	OE_TOOL_ACTION,
	/// end CENTRALIZE_TOOL_EVENTS

	OE_ON_DBL_CLICK_VERT_TAB,//--- CPY 12/1/05 QA70-8292 MAT_OBJ_PROP_DIALOG_WHEN_DBL_CLICK

	OE_ON_TABLE_CREATE,		/// RVD 4/7/2006 QA70-8609 v8.0387 TABLE_GRID_BORDERS
	
	OE_ON_TABLE_PROPS_DIALOG, //------------ CPY 6/19/2006 DBL_CLICK_TABLE_TO_OPEN_LINKED_WKS

	OE_ON_SET_REPORT, //---- CPY 8/18/06 REPORT_SHEET_SHOULD_HAVE_DIFF_THEME

	OE_ON_UPDATE_EMBED, /// TD 9-11-06 QA70-8950 NEW_SPARKLINE_GRAPHS
	OE_AUTOFILL,		/// RVD 2/19/2007 QA70-9371 v8.0566 WKS_SELECTION_FILL

	OE_AFTER_STARTUP_BUILD, /// TD 4-12-07 QA70-9603 OC_CONTROLLED_DIALOGBARS_AUTOLAUNCH_ON_ORIGIN_BEGIN
	
	//--------- CPY 5/17/07 QA70-9794 XF_SEPARATE_INTO_TWO_CLASSES_AND_CACHE
	OE_OC_FILE_NODE_EXCLUDED,
	//---------

	///Arvin 07/04/07 OPEN_OR_CLOSE_DATA_INFO_DLG
	//Add event to close data info dialog 
	OE_TOOL_CLOSE,
	///end OPEN_OR_CLOSE_DATA_INFO_DLG

	OE_ON_OBJ_DBL_CLICK,  //----- CPY 7/13/07 QA70-9062 SCALE_OBJ_EDIT_FROM_OC

	/// RVD 12/19/2008 qa70-12823 v8.0989 GROBJ_POST_MSG_NOT_RECEIVED
	OE_ORG_END,

	// msg sent/post to attached XF of the obj
	OE_XF_MSG=0x08000000, //--- CPY 5/24/05 QA70-7756 GRAPH_XF_OPEN_DIALOG_BY_POST_MSG

	// user events
	OE_USER = 0x10000000,	/// RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS
	/// end GROBJ_POST_MSG_NOT_RECEIVED

}	ORIGINEVENTID;



/// TD 11-12-04 QA70-7027 EVENT_HANDLING_ETC_FOR_OK
enum
{
	HGE_RESULTS_LOG = 1,
	HGE_RESULTS_SHEET,
	/// ML 12/22/2004 UNIFIED_GRID_CONTEXT_MENU_HANDLING
	HGE_TABLE_OBJ,
	/// end UNIFIED_GRID_CONTEXT_MENU_HANDLING
};
/// end EVENT_HANDLING_ETC_FOR_OK 

//---- CPY 6/28/06 REPORT_TABLE_CONTEXT_MENU_SHOULD_CHECK_SEL
#define HGE_TABLE_TITLE	0x1000	
#define HGE_MASK_TYPE	0x000F
#define HGE_TITLE_MENUBUTTON	0x2000/// TD ML 02-03-2010 QA81-15043 MENU_BUTTON_ON_REPORT_TABLE_TITLES
//----

/// RVD 12/19/2008 qa70-12823 v8.0989 GROBJ_POST_MSG_NOT_RECEIVED
/*
/// YuI 12/05/03 v7.5778 QA70-5613 OC_CMDTARGET_HANDLER_FOR_ORIGIN_OBJECTS
// this set of events intended to be handled by command target of different objects
typedef enum	tagORIGINCMDTARGETEVENTID
{
	OE_NONE = -1,
	// generic events 
	/// YuI 06/01/05 QA70-7755 CURSOR_OBJECT_IMPLEMENTATION
	// utterly generic Begin and end
	// use according to your needs and common sense
	OE_BEGIN,
	OE_END,
	/// end CURSOR_OBJECT_IMPLEMENTATION

	OE_MOVE,
	OE_MOVING,
	OE_RESIZE,
	OE_RESIZING,
	OE_DELETE,
	OE_SELECT,
	OE_UNSELECT,
	/// ML 6/22/2007 CANNOT_INSERT_MUST_APPEND_NEW_EVENT_VALUES
	//OE_NEWSELECTION,	/// RVD 6/14/2007 QA80-9872 v8.0642 SELECT_EVENT_OBJECT_ONLY
	/// end CANNOT_INSERT_MUST_APPEND_NEW_EVENT_VALUES
	OE_BUTTONCLICK,
	OE_INIT_ANCHORS,	/// RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS

	//graph object related 
	OE_GRAPHOBJ_ROTATE,
	OE_GRAPHOBJ_ROTATING,
	OE_GRAPHOBJ_SKEW,
	OE_GRAPHOBJ_SKEWING,
	OE_GRAPHOBJ_EDIT,
	OE_GRAPHOBJ_EDITING,

	/// ML 6/22/2007 CANNOT_INSERT_MUST_APPEND_NEW_EVENT_VALUES
	OE_NEWSELECTION,	/// RVD 6/14/2007 QA80-9872 v8.0642 SELECT_EVENT_OBJECT_ONLY
	OE_DELETE_PART,	/// RVD 4/1/2008 QA70-11338 v8.0836 DELETE_POLYLINE_SELECTED_POINT

	// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! //
	// All new events (< 500) must be added here, rather than inserted above.
	// This is because these event values are stored as STR_DATAID_ATTRIB
	// inside tree nodes of xfuncs.
	// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! //
	/// end CANNOT_INSERT_MUST_APPEND_NEW_EVENT_VALUES
	
	//------ CPY 11/29/06 QA70-9164 EVENT_ID_NEEDED_FROM_LT 
	OE_WIN_OPEN = 500,
	OE_WIN_CLOSE,
	OE_WIN_ACTIVATE,
	OE_WIN_DEACTIVATE,
	OE_BEFORE_SAVE,
	OE_SCALE_CHANGE,
	OE_UPDATE,	// internal call to UpdateData
	//------

	// msg sent/post to attached XF of the obj
	OE_XF_MSG=0x08000000, //--- CPY 5/24/05 QA70-7756 GRAPH_XF_OPEN_DIALOG_BY_POST_MSG

	// user events
	OE_USER = 0x10000000,	/// RVD 3/15/2005 QA70-7498 v8.0204 XFUNCTION_ANCHORS

}	ORIGINCMDTARGETEVENTID;
/// end OC_CMDTARGET_HANDLER_FOR_ORIGIN_OBJECTS

typedef	enum tagORIGINEVENTMESSAGE
{
	OE_MSG_FIRE,
	OE_MSG_SET_OGS_FILE_NAME,
}	ORIGINEVENTMESSAGE;
*/
/// RVD 1/23/2009 QA80-13011 PA_MARKER_ACTIVATION
//#define		IS_CMD_EVENT(_id)		((_id) >= OE_CMD_BEGIN && (_id) < OE_CMD_END)
//#define		IS_CMD_EVENT(_id)		((_id) >= OE_CMD_BEGIN && (_id) < OE_CMD_END)
#define		IS_CMD_EVENT(_id)		(((_id) & OE_USER) || ((_id) >= OE_CMD_BEGIN && (_id) < OE_CMD_END))
/// end PA_MARKER_ACTIVATION
#define		IS_OGS_EVENT(_id)		((_id) >= OE_OGS_BEGIN && (_id) < OE_OGS_END)
#define		IS_ORIGIN_EVENT(_id)	((_id) >= OE_ORG_BEGIN && (_id) < OE_ORG_END)
/// end GROBJ_POST_MSG_NOT_RECEIVED

//----- CPY 12/3/04 QA70-6376 WKS_CORNER_NEED_BETTER_HANDLING
#define OBE_MENU_CORNER							0x0100			/// TD 12-3-04 OLD_CORNER_MENU_REINSTATETD/// TD 10-04-04 QA70-7000 GETNTREE_TO_GENERATE_POPUP_MENUS
#define OBE_MENU_TITLE							0x0200	//----CPY 7/9/06 REPORT_TITLE_NEEDS_USER_COMMENTS
#define IS_WKS_TOP_LEFT_CORNER_OUTSIDE(_SEL) (((_SEL & NXY_LEFT) && (_SEL & NXY_TOP) && (NXY_OUT & _SEL))?true:false)	
//-----

#endif //_OEVENTS_H